/*
 * Decompiled with CFR 0.152.
 */
package top.prefersmin.banitem;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.slf4j.Logger;
import top.prefersmin.banitem.BanItemEvent;
import top.prefersmin.banitem.common.CommandRegister;
import top.prefersmin.banitem.config.BanItemConfig;

@Mod(value="banitem")
public class BanItem {
    public static final String MODID = "banitem";
    private static final Logger LOGGER = LogUtils.getLogger();

    public BanItem() {
        ModLoadingContext.get().registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (a, b) -> true));
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.addListener(this::registerCommands);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)BanItemConfig.SPEC);
    }

    public static boolean shouldDelete(ItemStack stack) {
        BanItemEvent event = new BanItemEvent(stack);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResult() == Event.Result.DEFAULT) {
            return ((List)BanItemConfig.ITEM_BLACKLIST.get()).contains(stack.m_41720_().m_5524_().replaceFirst("^(item|block)\\.", "").replaceFirst("\\.", ":"));
        }
        return event.getResult() == Event.Result.DENY;
    }

    private void registerCommands(RegisterCommandsEvent event) {
        CommandRegister.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinLevelEvent event) {
        if (event.getEntity() instanceof ItemEntity && BanItem.shouldDelete(((ItemEntity)event.getEntity()).m_32055_())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onItemPickup(PlayerEvent.ItemPickupEvent event) {
        if (BanItem.shouldDelete(event.getStack())) {
            if (event.isCancelable()) {
                event.setCanceled(true);
            } else {
                LOGGER.error("BanItem\uff1a\u73a9\u5bb6[{}]\u62fe\u53d6\u4e86\u9ed1\u540d\u5355\u7269\u54c1[{}]", (Object)event.getEntity(), (Object)event.getStack());
            }
        }
    }

    @SubscribeEvent
    public void onPlayerContainerOpen(PlayerContainerEvent event) {
        for (int i = 0; i < event.getContainer().f_38839_.size(); ++i) {
            if (!BanItem.shouldDelete((ItemStack)event.getContainer().m_38927_().get(i))) continue;
            event.getContainer().m_38927_().set(i, (Object)ItemStack.f_41583_);
        }
    }
}

